#include <language/utils/OperatorRepository.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/AffectationRegisterForB.hpp>
#include <language/utils/AffectationRegisterForN.hpp>
#include <language/utils/AffectationRegisterForR.hpp>
#include <language/utils/AffectationRegisterForR1.hpp>
#include <language/utils/AffectationRegisterForR2.hpp>
#include <language/utils/AffectationRegisterForR3.hpp>
#include <language/utils/AffectationRegisterForString.hpp>
#include <language/utils/AffectationRegisterForZ.hpp>
#include <language/utils/IncDecOperatorRegisterForN.hpp>
#include <language/utils/IncDecOperatorRegisterForR.hpp>
#include <language/utils/IncDecOperatorRegisterForZ.hpp>
#include <language/utils/UnaryOperatorRegisterForB.hpp>
#include <language/utils/UnaryOperatorRegisterForN.hpp>
#include <language/utils/UnaryOperatorRegisterForR.hpp>
#include <language/utils/UnaryOperatorRegisterForR1.hpp>
#include <language/utils/UnaryOperatorRegisterForR2.hpp>
#include <language/utils/UnaryOperatorRegisterForR3.hpp>
#include <language/utils/UnaryOperatorRegisterForZ.hpp>

#include <utils/PugsAssert.hpp>

OperatorRepository* OperatorRepository::m_instance = nullptr;

void
OperatorRepository::reset()
{
  m_affectation_builder_list.clear();
  m_inc_dec_operator_builder_list.clear();
  m_unary_operator_builder_list.clear();
  this->_initialize();
}

void
OperatorRepository::create()
{
  Assert(m_instance == nullptr, "AffectationRepository was already created");
  m_instance = new OperatorRepository;
  m_instance->_initialize();
}

void
OperatorRepository::destroy()
{
  Assert(m_instance != nullptr, "AffectationRepository was not created");
  delete m_instance;
  m_instance = nullptr;
}

void
OperatorRepository::_initialize()
{
  AffectationRegisterForB{};
  AffectationRegisterForN{};
  AffectationRegisterForZ{};
  AffectationRegisterForR{};
  AffectationRegisterForR1{};
  AffectationRegisterForR2{};
  AffectationRegisterForR3{};
  AffectationRegisterForString{};

  IncDecOperatorRegisterForN{};
  IncDecOperatorRegisterForR{};
  IncDecOperatorRegisterForZ{};

  UnaryOperatorRegisterForB{};
  UnaryOperatorRegisterForN{};
  UnaryOperatorRegisterForZ{};
  UnaryOperatorRegisterForR{};
  UnaryOperatorRegisterForR1{};
  UnaryOperatorRegisterForR2{};
  UnaryOperatorRegisterForR3{};
}
