#include <language/utils/UnaryOperatorRegisterForR1.hpp>

#include <language/utils/OperatorRepository.hpp>
#include <language/utils/UnaryOperatorProcessorBuilder.hpp>

void
UnaryOperatorRegisterForR1::_register_unary_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R1 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(1);

  repository.addUnaryOperator<language::unary_minus>(R1, std::make_shared<UnaryOperatorProcessorBuilder<
                                                           language::unary_minus, TinyVector<1>, TinyVector<1>>>());
}

UnaryOperatorRegisterForR1::UnaryOperatorRegisterForR1()
{
  this->_register_unary_minus();
}
