#include <language/utils/IncDecOperatorRegisterForR.hpp>

#include <language/utils/IncDecOperatorProcessorBuilder.hpp>
#include <language/utils/OperatorRepository.hpp>

void
IncDecOperatorRegisterForR::_register_unary_minusminus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addIncDecOperator<language::unary_minusminus>(R, std::make_shared<IncDecOperatorProcessorBuilder<
                                                                language::unary_minusminus, double_t>>());
}

void
IncDecOperatorRegisterForR::_register_unary_plusplus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addIncDecOperator<
    language::unary_plusplus>(R,
                              std::make_shared<IncDecOperatorProcessorBuilder<language::unary_plusplus, double_t>>());
}

void
IncDecOperatorRegisterForR::_register_post_minusminus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addIncDecOperator<
    language::post_minusminus>(R,
                               std::make_shared<IncDecOperatorProcessorBuilder<language::post_minusminus, double_t>>());
}

void
IncDecOperatorRegisterForR::_register_post_plusplus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R = ASTNodeDataType::build<ASTNodeDataType::double_t>();

  repository.addIncDecOperator<
    language::post_plusplus>(R, std::make_shared<IncDecOperatorProcessorBuilder<language::post_plusplus, double_t>>());
}

IncDecOperatorRegisterForR::IncDecOperatorRegisterForR()
{
  this->_register_unary_minusminus();
  this->_register_unary_plusplus();
  this->_register_post_minusminus();
  this->_register_post_plusplus();
}
