#include <language/utils/ASTExecutionInfo.hpp>

#include <language/ast/ASTNode.hpp>

const ASTExecutionInfo* ASTExecutionInfo::m_current_execution_info = nullptr;

ASTExecutionInfo::ASTExecutionInfo(const ASTNode& root_node, const ModuleRepository& module_repository)
  : m_root_node{root_node}, m_module_repository{module_repository}
{
  Assert(m_current_execution_info == nullptr, "Can only define one ASTExecutionInfo");

  m_current_execution_info = this;
}

const ASTExecutionInfo&
ASTExecutionInfo::current()
{
  Assert(m_current_execution_info != nullptr, "ASTExecutionInfo is not defined!");
  return *m_current_execution_info;
}

ASTExecutionInfo::~ASTExecutionInfo()
{
  m_current_execution_info = nullptr;
}
