#include <language/BuiltinModule.hpp>

#include <language/BuiltinFunctionEmbedder.hpp>
#include <language/TypeDescriptor.hpp>
#include <utils/Exceptions.hpp>

#include <iostream>

void
BuiltinModule::_addBuiltinFunction(const std::string& name,
                                   std::shared_ptr<IBuiltinFunctionEmbedder> builtin_function_embedder)
{
  auto [i_builtin_function, success] =
    m_name_builtin_function_map.insert(std::make_pair(name, builtin_function_embedder));
  if (not success) {
    throw NormalError("builtin-function '" + name + "' cannot be added!\n");
  }
}

void
BuiltinModule::_addTypeDescriptor(std::shared_ptr<TypeDescriptor> type_descriptor)
{
  auto [i_type, success] = m_name_type_map.insert(std::make_pair(type_descriptor->name(), type_descriptor));
  if (not success) {
    throw NormalError("type '" + type_descriptor->name() + "' cannot be added!\n");
  }
}
