#ifndef AST_NODE_NATURAL_CONVERSION_CHECKER_HPP
#define AST_NODE_NATURAL_CONVERSION_CHECKER_HPP

#include <language/ASTNode.hpp>
#include <language/ASTNodeDataType.hpp>
#include <language/ASTNodeSubDataType.hpp>

class ASTNodeNaturalConversionChecker
{
 private:
  void _checkIsNaturalTypeConversion(const ASTNode& ast_node,
                                     const ASTNodeDataType& data_type,
                                     const ASTNodeDataType& target_data_type) const;

  void _checkIsNaturalExpressionConversion(const ASTNode& ast_node,
                                           const ASTNodeDataType& data_type,
                                           const ASTNodeDataType& target_data_type) const;

 public:
  ASTNodeNaturalConversionChecker(const ASTNode& data_node, const ASTNodeDataType& target_data_type);

  ASTNodeNaturalConversionChecker(const ASTNodeSubDataType& data_node_sub_data_type,
                                  const ASTNodeDataType& target_data_type);
};

#endif   //  AST_NODE_NATURAL_CONVERSION_CHECKER_HPP
