#include <language/ASTNodeDataTypeFlattener.hpp>

#include <language/FunctionTable.hpp>
#include <language/PEGGrammar.hpp>
#include <language/SymbolTable.hpp>

ASTNodeDataTypeFlattener::ASTNodeDataTypeFlattener(ASTNode& node, FlattenedDataTypeList& flattened_datatype_list)
{
  if (node.is_type<language::expression_list>() or node.is_type<language::function_argument_list>()) {
    for (auto& child_node : node.children) {
      ASTNodeDataTypeFlattener{*child_node, flattened_datatype_list};
    }
  } else if (node.is_type<language::function_evaluation>()) {
    if (node.m_data_type != ASTNodeDataType::typename_t) {
      flattened_datatype_list.push_back({node.m_data_type, node});
    } else {
      ASTNode& function_name_node = *node.children[0];

      auto [i_function_symbol, found] = node.m_symbol_table->find(function_name_node.string(), node.begin());
      Assert(found);

      switch (i_function_symbol->attributes().dataType()) {
      case ASTNodeDataType::function_t: {
        uint64_t function_id = std::get<uint64_t>(i_function_symbol->attributes().value());

        FunctionDescriptor& function_descriptor = node.m_symbol_table->functionTable()[function_id];

        ASTNode& function_image_domain = *function_descriptor.domainMappingNode().children[1];

        for (auto& image_sub_domain : function_image_domain.children) {
          ASTNodeDataType data_type = ASTNodeDataType::undefined_t;

          if (image_sub_domain->is_type<language::B_set>()) {
            data_type = ASTNodeDataType::bool_t;
          } else if (image_sub_domain->is_type<language::Z_set>()) {
            data_type = ASTNodeDataType::int_t;
          } else if (image_sub_domain->is_type<language::N_set>()) {
            data_type = ASTNodeDataType::unsigned_int_t;
          } else if (image_sub_domain->is_type<language::R_set>()) {
            data_type = ASTNodeDataType::double_t;
          } else if (image_sub_domain->is_type<language::vector_type>()) {
            data_type = getVectorDataType(*image_sub_domain);
          } else if (image_sub_domain->is_type<language::string_type>()) {
            data_type = ASTNodeDataType::string_t;
          }

          Assert(data_type != ASTNodeDataType::undefined_t);
          flattened_datatype_list.push_back({data_type, node});
        }
        break;
      }
        //    LCOV_EXCL_START
      default: {
        throw parse_error("unexpected function type", node.begin());
      }
        //    LCOV_EXCL_STOP
      }
    }
  } else {
    flattened_datatype_list.push_back({node.m_data_type, node});
  }
}
