#include <language/ASTNodeDataTypeChecker.hpp>

void
ASTNodeDataTypeChecker::_checkNodeDataTypes(const ASTNode& n)
{
  if (n.m_data_type == ASTNodeDataType::undefined_t) {
    throw parse_error("unexpected error: undefined datatype for AST node for " + n.name(), n.begin());
  }

  for (const auto& child : n.children) {
    this->_checkNodeDataTypes(*child);
  }
}

ASTNodeDataTypeChecker::ASTNodeDataTypeChecker(const ASTNode& node)
{
  Assert(node.is_root());
  this->_checkNodeDataTypes(node);
  std::cout << " - checked node data types\n";
}
