#ifndef PUGS_TRAITS_HPP
#define PUGS_TRAITS_HPP

#include <type_traits>

template <size_t N, typename T>
class TinyVector;
template <size_t N, typename T>
class TinyMatrix;

template <typename T>
inline constexpr bool is_trivially_castable = std::is_trivial_v<T>;

template <size_t N, typename T>
inline constexpr bool is_trivially_castable<TinyVector<N, T>> =
  is_trivially_castable<T>;
template <size_t N, typename T>
inline constexpr bool is_trivially_castable<const TinyVector<N, T>> =
  is_trivially_castable<T>;

template <size_t N, typename T>
inline constexpr bool is_trivially_castable<TinyMatrix<N, T>> =
  is_trivially_castable<T>;
template <size_t N, typename T>
inline constexpr bool is_trivially_castable<const TinyMatrix<N, T>> =
  is_trivially_castable<T>;

template <typename T>
inline constexpr bool is_false_v = false;

#endif   // PUGS_TRAITS_HPP
