#ifndef PUGS_OSTREAM_HPP
#define PUGS_OSTREAM_HPP

#include <PugsMacros.hpp>
#include <iostream>
#include <sstream>

extern std::stringstream null_stream;

class PugsOStream
{
 private:
  std::ostream* m_os = nullptr;

 public:
  PUGS_INLINE
  std::ostream&
  operator()()
  {
    return *m_os;
  }

  void
  setOutput(std::ostream& os)
  {
    m_os = &os;
  }

  PugsOStream(std::ostream& os) : m_os(&os)
  {
    ;
  }

  PugsOStream& operator=(const PugsOStream&) = delete;
  PugsOStream& operator=(PugsOStream&&) = delete;
  PugsOStream(const PugsOStream&)       = delete;
  PugsOStream(PugsOStream&&)            = delete;

  ~PugsOStream() = default;
};

extern PugsOStream pout;
extern PugsOStream perr;
extern const PugsOStream _null_stream_initializer;

#endif   // PUGS_OSTREAM_HPP
