#ifndef BLOCK_PERFECTGAS_HPP
#define BLOCK_PERFECTGAS_HPP

#include <ItemValue.hpp>

struct BlockPerfectGas
{
 private:
  CellValue<double>& m_rhoj;
  CellValue<double>& m_ej;
  CellValue<double>& m_pj;
  CellValue<double>& m_gammaj;
  CellValue<double>& m_cj;

 public:
  BlockPerfectGas(CellValue<double>& rhoj,
                  CellValue<double>& ej,
                  CellValue<double>& pj,
                  CellValue<double>& gammaj,
                  CellValue<double>& cj)
    : m_rhoj(rhoj), m_ej(ej), m_pj(pj), m_gammaj(gammaj), m_cj(cj)
  {
    ;
  }

  void
  updatePandCFromRhoE()
  {
    const size_t nj                      = m_ej.size();
    const CellValue<const double>& rho   = m_rhoj;
    const CellValue<const double>& e     = m_ej;
    const CellValue<const double>& gamma = m_gammaj;

    parallel_for(nj, PUGS_LAMBDA(const CellId& j) {
      const double gamma_minus_one = gamma[j] - 1;
      m_pj[j]                      = gamma_minus_one * rho[j] * e[j];
      m_cj[j] = std::sqrt(gamma[j] * gamma_minus_one * e[j]);
    });
  }

  void
  updateEandCFromRhoP()
  {
    const size_t nj                      = m_ej.size();
    const CellValue<const double>& rho   = m_rhoj;
    const CellValue<const double>& p     = m_pj;
    const CellValue<const double>& gamma = m_gammaj;

    parallel_for(nj, PUGS_LAMBDA(const CellId& j) {
      m_ej[j] = p[j] / (rho[j] * (gamma[j] - 1));
    });

    const CellValue<const double>& e = m_ej;
    parallel_for(nj, PUGS_LAMBDA(const CellId& j) {
      m_cj[j] = std::sqrt(gamma[j] * (gamma[j] - 1) * e[j]);
    });
  }
};

#endif   // BLOCK_PERFECTGAS_HPP
