#ifndef ITEM_VALUE_VARIANT_FUNCTION_INTERPOLER_HPP
#define ITEM_VALUE_VARIANT_FUNCTION_INTERPOLER_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <mesh/IZoneDescriptor.hpp>
#include <mesh/ItemType.hpp>
#include <mesh/ItemValueVariant.hpp>

class ItemValueVariantFunctionInterpoler
{
 private:
  std::shared_ptr<const IMesh> m_mesh;
  const ItemType m_item_type;
  const FunctionSymbolId m_function_id;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  std::shared_ptr<ItemValueVariant> _interpolate() const;

  template <size_t Dimension>
  std::shared_ptr<ItemValueVariant> _interpolate() const;

 public:
  std::shared_ptr<ItemValueVariant> interpolate() const;

  ItemValueVariantFunctionInterpoler(const std::shared_ptr<const IMesh>& mesh,
                                     const ItemType& item_type,
                                     const FunctionSymbolId& function_id)
    : m_mesh{mesh}, m_item_type{item_type}, m_function_id{function_id}
  {}

  ItemValueVariantFunctionInterpoler(const ItemValueVariantFunctionInterpoler&) = delete;
  ItemValueVariantFunctionInterpoler(ItemValueVariantFunctionInterpoler&&)      = delete;

  ~ItemValueVariantFunctionInterpoler() = default;
};

#endif   // ITEM_VALUE_VARIANT_FUNCTION_INTERPOLER_HPP
