#ifndef AST_NODE_LIST_PROCESSOR_HPP
#define AST_NODE_LIST_PROCESSOR_HPP

#include <language/PEGGrammar.hpp>
#include <language/ast/ASTNode.hpp>
#include <language/node_processor/INodeProcessor.hpp>
#include <language/utils/SymbolTable.hpp>

class ASTNodeListProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    for (auto& child : m_node.children) {
      child->execute(exec_policy);
    }

    if (not(m_node.is_root() or m_node.is_type<language::for_statement_block>()))
      m_node.m_symbol_table->clearValues();

    return {};
  }

  ASTNodeListProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // AST_NODE_LIST_PROCESSOR_HPP
