#ifndef EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP
#define EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP

#include <language/utils/ASTNodeDataType.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

#include <string>

struct EmbeddedIDiscreteFunctionUtils
{
  template <typename T>
  static PUGS_INLINE std::string
  getOperandTypeName(const T& t)
  {
    if constexpr (is_shared_ptr_v<T>) {
      Assert(t.use_count() > 0, "dangling shared_ptr");
      return getOperandTypeName(*t);
    } else if constexpr (std::is_base_of_v<IDiscreteFunction, std::decay_t<T>>) {
      return "Vh(" + name(t.descriptor().type()) + ':' + dataTypeName(t.dataType()) + ')';
    } else {
      return dataTypeName(ast_node_data_type_from<T>);
    }
  }

  static bool isSameDiscretization(const IDiscreteFunction& f, const IDiscreteFunction& g);

  static PUGS_INLINE bool
  isSameDiscretization(const std::shared_ptr<const IDiscreteFunction>& f,
                       const std::shared_ptr<const IDiscreteFunction>& g)
  {
    return isSameDiscretization(*f, *g);
  }

  template <typename T1, typename T2>
  PUGS_INLINE static std::string
  incompatibleOperandTypes(const T1& t1, const T2& t2)
  {
    return "incompatible operand types " + getOperandTypeName(t1) + " and " + getOperandTypeName(t2);
  }

  template <typename T>
  PUGS_INLINE static std::string
  invalidOperandType(const T& t)
  {
    return "invalid operand type " + getOperandTypeName(t);
  }
};

#endif   // EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP
