#ifndef I_DISCRETE_FUNCTION_HPP
#define I_DISCRETE_FUNCTION_HPP

class IMesh;
class IDiscreteFunctionDescriptor;

#include <language/utils/ASTNodeDataTypeTraits.hpp>
#include <memory>

class IDiscreteFunction
{
 public:
  enum class HandledItemDataType
  {
    value,
    vector,
  };

  virtual std::shared_ptr<const IMesh> mesh() const             = 0;
  virtual const IDiscreteFunctionDescriptor& descriptor() const = 0;
  virtual ASTNodeDataType dataType() const                      = 0;

  IDiscreteFunction() = default;

  IDiscreteFunction(const IDiscreteFunction&) = default;

  IDiscreteFunction(IDiscreteFunction&&) noexcept = default;

  virtual ~IDiscreteFunction() noexcept = default;
};

#endif   // I_DISCRETE_FUNCTION_HPP
