#ifndef I_BOUNDARY_DESCRIPTOR_HPP
#define I_BOUNDARY_DESCRIPTOR_HPP

#include <mesh/RefId.hpp>

#include <iostream>

class IBoundaryDescriptor
{
 public:
  enum class Type
  {
    named,
    numbered
  };

 protected:
  virtual std::ostream& _write(std::ostream& os) const = 0;

 public:
  friend std::ostream&
  operator<<(std::ostream& os, const IBoundaryDescriptor& bd)
  {
    return bd._write(os);
  }

  virtual bool operator==(const RefId& ref_id) const = 0;
  friend bool
  operator==(const RefId& ref_id, const IBoundaryDescriptor& bcd)
  {
    return bcd == ref_id;
  }
  virtual Type type() const = 0;

  IBoundaryDescriptor(const IBoundaryDescriptor&) = delete;
  IBoundaryDescriptor(IBoundaryDescriptor&&)      = delete;
  IBoundaryDescriptor()                           = default;

  virtual ~IBoundaryDescriptor() = default;
};
#endif   // I_BOUNDARY_DESCRIPTOR_HPP
