#ifndef FOURIER_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define FOURIER_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <scheme/IBoundaryDescriptor.hpp>

#include <memory>

class FourierBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "fourier(" << m_name << ',' << *m_boundary_descriptor << ")";
    return os;
  }

  const std::string_view m_name;

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;
  const FunctionSymbolId m_mass_symbol_id;
  const FunctionSymbolId m_rhs_symbol_id;

 public:
  std::string_view
  name() const
  {
    return m_name;
  }

  FunctionSymbolId
  massSymbolId() const
  {
    return m_mass_symbol_id;
  }

  FunctionSymbolId
  rhsSymbolId() const
  {
    return m_rhs_symbol_id;
  }

  const IBoundaryDescriptor&
  boundaryDescriptor() const
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::fourier;
  }

  FourierBoundaryConditionDescriptor(const std::string_view name,
                                     std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor,
                                     const FunctionSymbolId& mass_symbol_id,
                                     const FunctionSymbolId& rhs_symbol_id)
    : m_name{name},
      m_boundary_descriptor(boundary_descriptor),
      m_mass_symbol_id{mass_symbol_id},
      m_rhs_symbol_id{rhs_symbol_id}
  {
    ;
  }

  FourierBoundaryConditionDescriptor(const FourierBoundaryConditionDescriptor&) = delete;
  FourierBoundaryConditionDescriptor(FourierBoundaryConditionDescriptor&&)      = delete;

  ~FourierBoundaryConditionDescriptor() = default;
};

#endif   // FOURIER_BOUNDARY_CONDITION_DESCRIPTOR_HPP
