#ifndef GNUPLOT_WRITER_HPP
#define GNUPLOT_WRITER_HPP

#include <output/WriterBase.hpp>

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <output/OutputNamedItemValueSet.hpp>

class IMesh;

#include <string>

class GnuplotWriter : public WriterBase
{
 private:
  std::string _getDateAndVersionComment() const;

  std::string _getFilename() const;

  template <typename DataType>
  void _writeCellData(const CellValue<DataType>& cell_value, CellId cell_id, std::ostream& fout) const;

  template <typename DataType>
  void _writeCellData(const CellArray<DataType>& cell_value, CellId cell_id, std::ostream& fout) const;

  template <typename DataType>
  void _writeNodeData(const NodeValue<DataType>& node_value, NodeId cell_id, std::ostream& fout) const;

  template <typename DataType>
  void _writeNodeData(const NodeArray<DataType>& node_value, NodeId cell_id, std::ostream& fout) const;

  template <size_t Dimension>
  void _writePreamble(const OutputNamedItemDataSet& output_named_item_data_set, std::ostream& fout) const;

  template <typename ItemDataT>
  void _writeData(const ItemDataT& item_data,
                  [[maybe_unused]] CellId cell_id,
                  [[maybe_unused]] NodeId node_id,
                  std::ostream& fout) const;

  template <typename MeshType>
  void _writeDataAtNodes(const std::shared_ptr<const MeshType>& mesh,
                         const OutputNamedItemDataSet& output_named_item_data_set,
                         std::ostream& fout) const;

  template <typename MeshType>
  void _write(const std::shared_ptr<const MeshType>& mesh,
              const OutputNamedItemDataSet& output_named_item_data_set,
              double time) const;

 public:
  void writeMesh(const std::shared_ptr<const IMesh>& mesh) const final;

  void write(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
             double time) const final;

  GnuplotWriter(const std::string& base_filename, const double time_period) : WriterBase(base_filename, time_period) {}

  ~GnuplotWriter() = default;
};

#endif   // GNUPLOT_WRITER_HPP
