#include <mesh/MeshBuilderBase.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/ConnectivityDescriptor.hpp>
#include <mesh/ConnectivityDispatcher.hpp>
#include <mesh/ItemId.hpp>
#include <mesh/Mesh.hpp>
#include <utils/PugsAssert.hpp>
#include <utils/PugsMacros.hpp>

#include <vector>

template <int Dimension>
void
MeshBuilderBase::_dispatch()
{
  if (parallel::size() == 1) {
    return;
  }

  using ConnectivityType = Connectivity<Dimension>;
  using Rd               = TinyVector<Dimension>;
  using MeshType         = Mesh<ConnectivityType>;

  if (not m_mesh) {
    ConnectivityDescriptor descriptor;
    std::shared_ptr connectivity = ConnectivityType::build(descriptor);
    NodeValue<Rd> xr;
    m_mesh = std::make_shared<MeshType>(connectivity, xr);
  }
  const MeshType& mesh = static_cast<const MeshType&>(*m_mesh);

  ConnectivityDispatcher<Dimension> dispatcher(mesh.connectivity());

  std::shared_ptr dispatched_connectivity = dispatcher.dispatchedConnectivity();
  NodeValue<Rd> dispatched_xr             = dispatcher.dispatch(mesh.xr());

  m_mesh = std::make_shared<MeshType>(dispatched_connectivity, dispatched_xr);
}

template void MeshBuilderBase::_dispatch<1>();
template void MeshBuilderBase::_dispatch<2>();
template void MeshBuilderBase::_dispatch<3>();
