#ifndef DIAMOND_DUAL_MESH_MANAGER_HPP
#define DIAMOND_DUAL_MESH_MANAGER_HPP

#include <mesh/IMesh.hpp>
#include <utils/PugsAssert.hpp>
#include <utils/PugsMacros.hpp>

#include <memory>
#include <unordered_map>

template <size_t Dimension>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

class DiamondDualMeshManager
{
 private:
  std::unordered_map<const IMesh*, std::shared_ptr<const IMesh>> m_mesh_to_diamond_dual_mesh_map;

  static DiamondDualMeshManager* m_instance;

  DiamondDualMeshManager(const DiamondDualMeshManager&) = delete;
  DiamondDualMeshManager(DiamondDualMeshManager&&)      = delete;

  DiamondDualMeshManager()  = default;
  ~DiamondDualMeshManager() = default;

 public:
  static void create();
  static void destroy();

  PUGS_INLINE
  static DiamondDualMeshManager&
  instance()
  {
    Assert(m_instance != nullptr, "DiamondDualMeshManager was not created!");
    return *m_instance;
  }

  void deleteMesh(const IMesh*);

  template <size_t Dimension>
  std::shared_ptr<const Mesh<Connectivity<Dimension>>> getDiamondDualMesh(
    std::shared_ptr<const Mesh<Connectivity<Dimension>>>);
};

#endif   // DIAMOND_DUAL_MESH_MANAGER_HPP
