#include <language/utils/BinaryOperatorRegisterForZ.hpp>

#include <language/utils/BasicBinaryOperatorRegisterComparisonOf.hpp>

void
BinaryOperatorRegisterForZ::_register_comparisons()
{
  BasicBinaryOperatorRegisterComparisonOf<bool, int64_t>{};
  BasicBinaryOperatorRegisterComparisonOf<int64_t, bool>{};

  BasicBinaryOperatorRegisterComparisonOf<uint64_t, int64_t>{};
  BasicBinaryOperatorRegisterComparisonOf<int64_t, uint64_t>{};

  BasicBinaryOperatorRegisterComparisonOf<int64_t, int64_t>{};
}

template <typename OperatorT>
void
BinaryOperatorRegisterForZ::_register_arithmetic()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<OperatorT>(
    std::make_shared<BinaryOperatorProcessorBuilder<OperatorT, int64_t, int64_t, bool>>());
  repository.addBinaryOperator<OperatorT>(
    std::make_shared<BinaryOperatorProcessorBuilder<OperatorT, int64_t, bool, int64_t>>());

  repository.addBinaryOperator<OperatorT>(
    std::make_shared<BinaryOperatorProcessorBuilder<OperatorT, int64_t, int64_t, uint64_t>>());
  repository.addBinaryOperator<OperatorT>(
    std::make_shared<BinaryOperatorProcessorBuilder<OperatorT, int64_t, uint64_t, int64_t>>());

  repository.addBinaryOperator<OperatorT>(
    std::make_shared<BinaryOperatorProcessorBuilder<OperatorT, int64_t, int64_t, int64_t>>());
}

BinaryOperatorRegisterForZ::BinaryOperatorRegisterForZ()
{
  this->_register_comparisons();
  this->_register_arithmetic<language::plus_op>();
  this->_register_arithmetic<language::minus_op>();
  this->_register_arithmetic<language::multiply_op>();
  this->_register_arithmetic<language::divide_op>();
}
