#include <language/utils/OperatorRepository.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/AffectationRegisterForB.hpp>
#include <language/utils/AffectationRegisterForN.hpp>
#include <language/utils/AffectationRegisterForR.hpp>
#include <language/utils/AffectationRegisterForRn.hpp>
#include <language/utils/AffectationRegisterForRnxn.hpp>
#include <language/utils/AffectationRegisterForString.hpp>
#include <language/utils/AffectationRegisterForZ.hpp>

#include <language/utils/BinaryOperatorRegisterForB.hpp>
#include <language/utils/BinaryOperatorRegisterForN.hpp>
#include <language/utils/BinaryOperatorRegisterForR.hpp>
#include <language/utils/BinaryOperatorRegisterForRn.hpp>
#include <language/utils/BinaryOperatorRegisterForRnxn.hpp>
#include <language/utils/BinaryOperatorRegisterForString.hpp>
#include <language/utils/BinaryOperatorRegisterForZ.hpp>

#include <language/utils/IncDecOperatorRegisterForN.hpp>
#include <language/utils/IncDecOperatorRegisterForR.hpp>
#include <language/utils/IncDecOperatorRegisterForZ.hpp>

#include <language/utils/UnaryOperatorRegisterForB.hpp>
#include <language/utils/UnaryOperatorRegisterForN.hpp>
#include <language/utils/UnaryOperatorRegisterForR.hpp>
#include <language/utils/UnaryOperatorRegisterForRn.hpp>
#include <language/utils/UnaryOperatorRegisterForRnxn.hpp>
#include <language/utils/UnaryOperatorRegisterForZ.hpp>

#include <utils/PugsAssert.hpp>

OperatorRepository* OperatorRepository::m_instance = nullptr;

void
OperatorRepository::reset()
{
  m_affectation_builder_list.clear();
  m_binary_operator_builder_list.clear();
  m_inc_dec_operator_builder_list.clear();
  m_unary_operator_builder_list.clear();
  this->_initialize();
}

void
OperatorRepository::create()
{
  Assert(m_instance == nullptr, "AffectationRepository was already created");
  m_instance = new OperatorRepository;
  m_instance->_initialize();
}

void
OperatorRepository::destroy()
{
  Assert(m_instance != nullptr, "AffectationRepository was not created");
  delete m_instance;
  m_instance = nullptr;
}

void
OperatorRepository::_initialize()
{
  AffectationRegisterForB{};
  AffectationRegisterForN{};
  AffectationRegisterForZ{};
  AffectationRegisterForR{};
  AffectationRegisterForRn<1>{};
  AffectationRegisterForRn<2>{};
  AffectationRegisterForRn<3>{};
  AffectationRegisterForRnxn<1>{};
  AffectationRegisterForRnxn<2>{};
  AffectationRegisterForRnxn<3>{};
  AffectationRegisterForString{};

  BinaryOperatorRegisterForB{};
  BinaryOperatorRegisterForN{};
  BinaryOperatorRegisterForZ{};
  BinaryOperatorRegisterForR{};
  BinaryOperatorRegisterForRn<1>{};
  BinaryOperatorRegisterForRn<2>{};
  BinaryOperatorRegisterForRn<3>{};
  BinaryOperatorRegisterForRnxn<1>{};
  BinaryOperatorRegisterForRnxn<2>{};
  BinaryOperatorRegisterForRnxn<3>{};
  BinaryOperatorRegisterForString{};

  IncDecOperatorRegisterForN{};
  IncDecOperatorRegisterForR{};
  IncDecOperatorRegisterForZ{};

  UnaryOperatorRegisterForB{};
  UnaryOperatorRegisterForN{};
  UnaryOperatorRegisterForZ{};
  UnaryOperatorRegisterForR{};
  UnaryOperatorRegisterForRn<1>{};
  UnaryOperatorRegisterForRn<2>{};
  UnaryOperatorRegisterForRn<3>{};
  UnaryOperatorRegisterForRnxn<1>{};
  UnaryOperatorRegisterForRnxn<2>{};
  UnaryOperatorRegisterForRnxn<3>{};
}
