#ifndef FOR_PROCESSOR_HPP
#define FOR_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

class ForProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    ExecutionPolicy exec_until_jump;
    m_node.children[0]->execute(exec_policy);
    while ([&]() {
      return static_cast<bool>(std::visit(
        [](auto&& value) -> bool {
          using T = std::decay_t<decltype(value)>;
          if constexpr (std::is_arithmetic_v<T>) {
            return value;
          } else {
            return false;   // LCOV_EXCL_LINE (unreachable: only there for compilation purpose)
          }
        },
        m_node.children[1]->execute(exec_policy)));
    }()) {
      m_node.children[3]->execute(exec_until_jump);
      if (not exec_until_jump.exec()) {
        if (exec_until_jump.jumpType() == ExecutionPolicy::JumpType::break_jump) {
          break;
        } else if (exec_until_jump.jumpType() == ExecutionPolicy::JumpType::continue_jump) {
          exec_until_jump = ExecutionPolicy{};   // getting ready for next loop traversal
        }
      }

      m_node.children[2]->execute(exec_policy);
    }
    return {};
  }

  ForProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // FOR_PROCESSOR_HPP
