#ifndef NODE_PROCESSOR_HPP
#define NODE_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

#include <ASTNode.hpp>
#include <SymbolTable.hpp>

class NameProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  DataVariant* p_value{nullptr};

 public:
  DataVariant
  execute(ExecutionPolicy&)
  {
    return *p_value;
  }

  NameProcessor(ASTNode& node) : m_node{node}
  {
    const std::string& symbol = m_node.string();
    auto [i_symbol, found]    = m_node.m_symbol_table->find(symbol, m_node.begin());
    Assert(found);
    p_value = &(i_symbol->attributes().value());
  }
};

#endif   // NODE_PROCESSOR_HPP
