#include <utils/PugsAssert.hpp>

#include <mesh/Synchronizer.hpp>
#include <mesh/SynchronizerManager.hpp>

SynchronizerManager* SynchronizerManager::m_instance{nullptr};

SynchronizerManager::~SynchronizerManager()
{
  if (m_connectivity_synchronizer_map.size() > 0) {
    std::cerr << __FILE__ << ':' << __LINE__ << ": warning: some connectivities are still registered\n";
    ;
  }
}

void
SynchronizerManager::create()
{
  Assert(m_instance == nullptr, "SynchronizerManager is already created");
  m_instance = new SynchronizerManager;
}

void
SynchronizerManager::destroy()
{
  Assert(m_instance != nullptr, "SynchronizerManager was not created!");
  delete m_instance;
  m_instance = nullptr;
}

void
SynchronizerManager::deleteConnectivitySynchronizer(const IConnectivity* connectivity)
{
  m_connectivity_synchronizer_map.erase(connectivity);
}

Synchronizer&
SynchronizerManager::getConnectivitySynchronizer(const IConnectivity* connectivity)
{
  if (auto connectivity_synchronizer = m_connectivity_synchronizer_map.find(connectivity);
      connectivity_synchronizer != m_connectivity_synchronizer_map.end()) {
    return (*connectivity_synchronizer->second);
  } else {
    std::shared_ptr synchronizer                  = std::make_shared<Synchronizer>();
    m_connectivity_synchronizer_map[connectivity] = synchronizer;
    return *synchronizer;
  }
}
