#ifndef OSTREAM_PROCESSOR_HPP
#define OSTREAM_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

class OStreamProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  std::ostream& m_os;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    for (size_t i = 0; i < m_node.children.size(); ++i) {
      std::visit(
        [&](auto&& value) {
          using ValueT = std::decay_t<decltype(value)>;
          if constexpr (not std::is_same_v<std::monostate, ValueT>) {
            if constexpr (std::is_same_v<bool, ValueT>) {
              m_os << std::boolalpha << value;
            } else {
              m_os << value;
            }
          }
        },
        m_node.children[i]->execute(exec_policy));
    }

    return {};
  }

  OStreamProcessor(ASTNode& node, std::ostream& os) : m_node{node}, m_os(os)
  {
    ;
  }
};

#endif   // OSTREAM_PROCESSOR_HPP
