#ifndef SYMMETRY_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define SYMMETRY_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class SymmetryBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "symmetry(" << m_name << ',' << *m_boundary_descriptor << ")";
    return os;
  }

  const std::string_view m_name;

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  std::string_view
  name() const
  {
    return m_name;
  }
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::symmetry;
  }

  SymmetryBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {
    ;
  }

  SymmetryBoundaryConditionDescriptor(const SymmetryBoundaryConditionDescriptor&) = delete;
  SymmetryBoundaryConditionDescriptor(SymmetryBoundaryConditionDescriptor&&)      = delete;

  ~SymmetryBoundaryConditionDescriptor() = default;
};

#endif   // SYMMETRY_BOUNDARY_CONDITION_DESCRIPTOR_HPP
