#ifndef ELASTICITY_DIAMOND_ALGORITHM_HPP
#define ELASTICITY_DIAMOND_ALGORITHM_HPP

#include <algebra/TinyVector.hpp>
#include <language/utils/FunctionSymbolId.hpp>
#include <memory>
#include <mesh/IMesh.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <variant>
#include <vector>

template <size_t Dimension>
class ElasticityDiamondScheme
{
 private:
  class DirichletBoundaryCondition;
  class NormalStrainBoundaryCondition;
  class SymmetryBoundaryCondition;

 public:
  ElasticityDiamondScheme(std::shared_ptr<const IMesh> i_mesh,
                          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                          const FunctionSymbolId& lambda_id,
                          const FunctionSymbolId& mu_id,
                          const FunctionSymbolId& f_id,
                          const FunctionSymbolId& U_id);
};

#endif   // ELASTICITY_DIAMOND_ALGORITHM2_HPP
