#include <algebra/LeastSquareSolver.hpp>

#include <algebra/CG.hpp>

template <typename T>
void
LeastSquareSolver::solveLocalSystem(const SmallMatrix<T>& A, SmallVector<T>& x, const SmallVector<T>& b)
{
  if (A.numberOfRows() >= A.numberOfColumns()) {
    const SmallMatrix tA = transpose(A);
    const SmallMatrix B  = tA * A;
    const SmallVector y  = tA * b;
    CG{B, x, y, 1e-12, 10, false};
  } else {
    const SmallMatrix tA = transpose(A);
    const SmallMatrix B  = A * tA;
    SmallVector<double> y{A.numberOfRows()};
    y = zero;
    CG{B, y, b, 1e-12, 10, false};

    x = tA * y;
  }
}

template void LeastSquareSolver::solveLocalSystem(const SmallMatrix<double>&,
                                                  SmallVector<double>&,
                                                  const SmallVector<double>&);
