#ifndef REF_NODE_LIST_HPP
#define REF_NODE_LIST_HPP

#include <Array.hpp>
#include <RefId.hpp>

class RefNodeList
{
 private:
  RefId m_ref_id;
  Array<const NodeId> m_node_id_list;

 public:
  const RefId& refId() const
  {
    return m_ref_id;
  }

  const Array<const NodeId>& nodeList() const
  {
    return m_node_id_list;
  }

  RefNodeList(const RefId& ref_id,
              const Array<const NodeId>& node_id_list)
      : m_ref_id(ref_id),
        m_node_id_list(node_id_list)
  {
    ;
  }

  RefNodeList& operator=(const RefNodeList&) = default;
  RefNodeList& operator=(RefNodeList&&) = default;

  RefNodeList() = default;
  RefNodeList(const RefNodeList&) = default;
  ~RefNodeList() = default;
};

#endif // REF_NODE_LIST_HPP
