#ifndef REF_FACE_LIST_HPP
#define REF_FACE_LIST_HPP

#include <Array.hpp>
#include <RefId.hpp>

class RefFaceList
{
 private:
  const RefId m_ref_id;
  const Array<const FaceId> m_face_id_list;

 public:
  const RefId& refId() const
  {
    return m_ref_id;
  }

  const Array<const FaceId>& faceList() const
  {
    return m_face_id_list;
  }

  RefFaceList(const RefId& ref_id,
              const Array<const FaceId>& face_id_list)
      : m_ref_id(ref_id),
        m_face_id_list(face_id_list)
  {
    ;
  }

  RefFaceList& operator=(const RefFaceList&) = default;
  RefFaceList& operator=(RefFaceList&&) = default;

  RefFaceList() = default;
  RefFaceList(const RefFaceList&) = default;
  ~RefFaceList() = default;
};

#endif // REF_FACE_LIST_HPP
