#ifndef ICONNECTIVITY_HPP
#define ICONNECTIVITY_HPP

#include <ItemType.hpp>
#include <ConnectivityMatrix.hpp>

class IConnectivity
{
 protected:
  template <typename DataType,
            ItemType sub_item_type,
            ItemType item_type,
            typename Allowed>
  friend
  class SubItemValuePerItem;

  virtual const ConnectivityMatrix&
  _getMatrix(const ItemType& item_type_0,
             const ItemType& item_type_1) const = 0;

 public:
  virtual size_t numberOfNodes() const = 0;
  virtual size_t numberOfEdges() const = 0;
  virtual size_t numberOfFaces() const = 0;
  virtual size_t numberOfCells() const = 0;

  template <ItemType item_type>
  size_t numberOf() const = delete;

  IConnectivity() = default;
  IConnectivity(const IConnectivity&) = delete;
  ~IConnectivity() = default;
};

template <>
PASTIS_INLINE
size_t IConnectivity::numberOf<ItemType::node>() const
{
  return this->numberOfNodes();
}

template <>
PASTIS_INLINE
size_t IConnectivity::numberOf<ItemType::edge>() const
{
  return this->numberOfEdges();
}

template <>
PASTIS_INLINE
size_t IConnectivity::numberOf<ItemType::face>() const
{
  return this->numberOfFaces();
}

template <>
PASTIS_INLINE
size_t IConnectivity::numberOf<ItemType::cell>() const
{
  return this->numberOfCells();
}

#endif // ICONNECTIVITY_HPP
