#ifndef MESH_RANDOMIZER_HPP
#define MESH_RANDOMIZER_HPP

#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <vector>

class FunctionSymbolId;

class MeshRandomizerHandler
{
 private:
  template <size_t Dimension>
  class MeshRandomizer;

 public:
  std::shared_ptr<const IMesh> getRandomizedMesh(
    const IMesh& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const;

  std::shared_ptr<const IMesh> getRandomizedMesh(
    const IMesh& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const FunctionSymbolId& function_symbol_id) const;

  MeshRandomizerHandler()                        = default;
  MeshRandomizerHandler(MeshRandomizerHandler&&) = default;
  ~MeshRandomizerHandler()                       = default;
};

#endif   // MESH_RANDOMIZER_HPP
