#ifndef MESH_FACE_BOUNDARY_HPP
#define MESH_FACE_BOUNDARY_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/IBoundaryDescriptor.hpp>
#include <mesh/ItemValue.hpp>
#include <mesh/RefItemList.hpp>
#include <utils/Array.hpp>

template <size_t Dimension>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <size_t Dimension>
class MeshFaceBoundary   // clazy:exclude=copyable-polymorphic
{
 protected:
  Array<const FaceId> m_face_list;
  std::string m_boundary_name;

  std::array<TinyVector<Dimension>, Dimension*(Dimension - 1)> _getBounds(
    const Mesh<Connectivity<Dimension>>& mesh) const;

 public:
  template <size_t MeshDimension>
  friend MeshFaceBoundary<MeshDimension> getMeshFaceBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                             const IBoundaryDescriptor& boundary_descriptor);

  MeshFaceBoundary& operator=(const MeshFaceBoundary&) = default;
  MeshFaceBoundary& operator=(MeshFaceBoundary&&) = default;

  const Array<const FaceId>&
  faceList() const
  {
    return m_face_list;
  }

 protected:
  MeshFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list);

 public:
  MeshFaceBoundary(const MeshFaceBoundary&) = default;
  MeshFaceBoundary(MeshFaceBoundary&&)      = default;

  MeshFaceBoundary()          = default;
  virtual ~MeshFaceBoundary() = default;
};

template <size_t Dimension>
MeshFaceBoundary<Dimension> getMeshFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_FACE_BOUNDARY_HPP
