#include <mesh/DiamondDualMeshBuilder.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/ConnectivityToDiamondDualConnectivityDataMapper.hpp>
#include <mesh/DiamondDualConnectivityBuilder.hpp>
#include <mesh/DiamondDualConnectivityManager.hpp>
#include <mesh/ItemValueUtils.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>

template <size_t Dimension>
void
DiamondDualMeshBuilder::_buildDualDiamondMeshFrom(const std::shared_ptr<const IMesh>& p_i_mesh)
{
  using ConnectivityType = Connectivity<Dimension>;
  using MeshType         = Mesh<Connectivity<Dimension>>;

  std::shared_ptr p_primal_mesh = std::dynamic_pointer_cast<const MeshType>(p_i_mesh);
  const MeshType& primal_mesh   = *p_primal_mesh;

  DiamondDualConnectivityManager& manager = DiamondDualConnectivityManager::instance();

  std::shared_ptr<const ConnectivityType> p_diamond_connectivity =
    manager.getDiamondDualConnectivity(primal_mesh.connectivity());

  const ConnectivityType& diamond_connectivity = *p_diamond_connectivity;

  const NodeValue<const TinyVector<Dimension>> primal_xr = primal_mesh.xr();

  MeshData<Dimension>& primal_mesh_data                  = MeshDataManager::instance().getMeshData(primal_mesh);
  const CellValue<const TinyVector<Dimension>> primal_xj = primal_mesh_data.xj();

  std::shared_ptr connectivity_to_diamond_dual_connectivity_data_mapper =
    manager.getConnectivityToDiamondDualConnectivityDataMapper(primal_mesh.connectivity());

  NodeValue<TinyVector<Dimension>> diamond_xr{diamond_connectivity};
  connectivity_to_diamond_dual_connectivity_data_mapper->toDualNode(primal_xr, primal_xj, diamond_xr);

  m_mesh = std::make_shared<MeshType>(p_diamond_connectivity, diamond_xr);
}

DiamondDualMeshBuilder::DiamondDualMeshBuilder(const std::shared_ptr<const IMesh>& p_mesh)
{
  std::cout << "building DiamondDualMesh\n";

  switch (p_mesh->dimension()) {
  case 1: {
    this->_buildDualDiamondMeshFrom<1>(p_mesh);
    break;
  }
  case 2: {
    this->_buildDualDiamondMeshFrom<2>(p_mesh);
    break;
  }
  case 3: {
    this->_buildDualDiamondMeshFrom<3>(p_mesh);
    break;
  }
  default: {
    throw UnexpectedError("invalid mesh dimension: " + std::to_string(p_mesh->dimension()));
  }
  }
}
