#ifndef DIAMOND_DUAL_CONNECTIVITY_MANAGER_HPP
#define DIAMOND_DUAL_CONNECTIVITY_MANAGER_HPP

#include <mesh/IConnectivity.hpp>

#include <memory>
#include <unordered_map>

template <size_t Dimension>
class Connectivity;

class IConnectivityToDiamondDualConnectivityDataMapper;

template <size_t Dimension>
class ConnectivityToDiamondDualConnectivityDataMapper;

class DiamondDualConnectivityManager
{
 private:
  class DiamondDualConnectivityInfo
  {
   private:
    std::shared_ptr<const IConnectivity> m_diamond_dual_connectivity;
    std::shared_ptr<const IConnectivityToDiamondDualConnectivityDataMapper>
      m_connectivity_to_diamond_dual_connectivity_data_mapper;

   public:
    PUGS_INLINE
    std::shared_ptr<const IConnectivity>
    diamondDualConnectivity() const
    {
      return m_diamond_dual_connectivity;
    }

    PUGS_INLINE
    std::shared_ptr<const IConnectivityToDiamondDualConnectivityDataMapper>
    connectivityToDiamondDualConnectivityDataMapper()
    {
      return m_connectivity_to_diamond_dual_connectivity_data_mapper;
    }

    DiamondDualConnectivityInfo& operator=(const DiamondDualConnectivityInfo&) = default;
    DiamondDualConnectivityInfo& operator=(DiamondDualConnectivityInfo&&) = default;

    DiamondDualConnectivityInfo()                                   = default;
    DiamondDualConnectivityInfo(const DiamondDualConnectivityInfo&) = default;
    DiamondDualConnectivityInfo(DiamondDualConnectivityInfo&&)      = default;

    DiamondDualConnectivityInfo(const std::shared_ptr<const IConnectivity>& diamond_dual_connectivity,
                                const std::shared_ptr<const IConnectivityToDiamondDualConnectivityDataMapper>&
                                  connectivity_to_diamond_dual_connectivity_data_mapper)
      : m_diamond_dual_connectivity{diamond_dual_connectivity},
        m_connectivity_to_diamond_dual_connectivity_data_mapper{connectivity_to_diamond_dual_connectivity_data_mapper}
    {}

    ~DiamondDualConnectivityInfo() = default;
  };

  DiamondDualConnectivityInfo _getDiamondDualConnectivityInfo(const IConnectivity& connectivity);

  std::unordered_map<const IConnectivity*, DiamondDualConnectivityInfo>
    m_connectivity_to_diamond_dual_connectivity_info_map;

  static DiamondDualConnectivityManager* m_instance;

  DiamondDualConnectivityManager(const DiamondDualConnectivityManager&) = delete;
  DiamondDualConnectivityManager(DiamondDualConnectivityManager&&)      = delete;

  DiamondDualConnectivityManager()  = default;
  ~DiamondDualConnectivityManager() = default;

 public:
  static void create();
  static void destroy();

  PUGS_INLINE
  static DiamondDualConnectivityManager&
  instance()
  {
    Assert(m_instance != nullptr, "DiamondDualConnectivityManager was not created!");
    return *m_instance;
  }

  void deleteConnectivity(const IConnectivity*);

  template <size_t Dimension>
  std::shared_ptr<const Connectivity<Dimension>> getDiamondDualConnectivity(const Connectivity<Dimension>&);

  template <size_t Dimension>
  std::shared_ptr<const ConnectivityToDiamondDualConnectivityDataMapper<Dimension>>
  getConnectivityToDiamondDualConnectivityDataMapper(const Connectivity<Dimension>&);
};

#endif   // DIAMOND_DUAL_CONNECTIVITY_MANAGER_HPP
