#include <analysis/QuadratureManager.hpp>
#include <language/PugsParser.hpp>
#include <mesh/DiamondDualConnectivityManager.hpp>
#include <mesh/DiamondDualMeshManager.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/SynchronizerManager.hpp>
#include <utils/PugsUtils.hpp>
#include <utils/RandomEngine.hpp>

int
main(int argc, char* argv[])
{
  std::string filename = initialize(argc, argv);

  SynchronizerManager::create();
  RandomEngine::create();
  QuadratureManager::create();
  MeshDataManager::create();
  DiamondDualConnectivityManager::create();
  DiamondDualMeshManager::create();

  parser(filename);

  DiamondDualMeshManager::destroy();
  DiamondDualConnectivityManager::destroy();
  MeshDataManager::destroy();
  RandomEngine::destroy();
  QuadratureManager::destroy();
  SynchronizerManager::destroy();

  finalize();

  return 0;
}
