#include <language/modules/WriterModule.hpp>

#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/TypeDescriptor.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/GmshReader.hpp>
#include <mesh/Mesh.hpp>
#include <output/GnuplotWriter.hpp>
#include <output/GnuplotWriter1D.hpp>
#include <output/IWriter.hpp>
#include <output/NamedDiscreteFunction.hpp>
#include <output/VTKWriter.hpp>
#include <scheme/DiscreteFunctionP0.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

WriterModule::WriterModule()
{
  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const NamedDiscreteFunction>>);

  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const IWriter>>);

  this->_addBuiltinFunction("vtk_writer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IWriter>(const std::string&,
                                                                                                    const double&)>>(

                              [](const std::string& filename, const double& period) {
                                return std::make_shared<VTKWriter>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("gnuplot_writer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IWriter>(const std::string&,
                                                                                                    const double&)>>(

                              [](const std::string& filename, const double& period) {
                                return std::make_shared<GnuplotWriter>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("gnuplot_1d_writer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IWriter>(const std::string&,
                                                                                                    const double&)>>(

                              [](const std::string& filename, const double& period) {
                                return std::make_shared<GnuplotWriter1D>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("name_output",
                            std::make_shared<BuiltinFunctionEmbedder<
                              std::shared_ptr<const NamedDiscreteFunction>(std::shared_ptr<const IDiscreteFunction>,
                                                                           const std::string&)>>(

                              [](std::shared_ptr<const IDiscreteFunction> discrete_function,
                                 const std::string& name) -> std::shared_ptr<const NamedDiscreteFunction> {
                                return std::make_shared<const NamedDiscreteFunction>(discrete_function, name);
                              }

                              ));

  this->_addBuiltinFunction("write_mesh",
                            std::make_shared<BuiltinFunctionEmbedder<void(std::shared_ptr<const IWriter>,
                                                                          std::shared_ptr<const IMesh>)>>(

                              [](std::shared_ptr<const IWriter> writer, std::shared_ptr<const IMesh> p_mesh) -> void {
                                writer->writeMesh(p_mesh);
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::make_shared<BuiltinFunctionEmbedder<
                              void(std::shared_ptr<const IWriter>,
                                   const std::vector<std::shared_ptr<const NamedDiscreteFunction>>&, const double&)>>(

                              [](std::shared_ptr<const IWriter> writer,
                                 const std::vector<std::shared_ptr<const NamedDiscreteFunction>>&
                                   named_discrete_function_list,
                                 const double& time) -> void {
                                writer->writeIfNeeded(named_discrete_function_list, time);
                              }

                              ));

  this->_addBuiltinFunction("force_write",
                            std::make_shared<BuiltinFunctionEmbedder<
                              void(std::shared_ptr<const IWriter>,
                                   const std::vector<std::shared_ptr<const NamedDiscreteFunction>>&, const double&)>>(

                              [](std::shared_ptr<const IWriter> writer,
                                 const std::vector<std::shared_ptr<const NamedDiscreteFunction>>&
                                   named_discrete_function_list,
                                 const double& time) -> void {
                                writer->writeForced(named_discrete_function_list, time);
                              }

                              ));
}

void
WriterModule::registerOperators() const
{}
