#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_all.hpp>

#include <test_BinaryExpressionProcessor_utils.hpp>
#include <utils/pugs_config.hpp>

#include <fstream>
#include <netdb.h>
#include <unistd.h>

// clazy:excludeall=non-pod-global-static

TEST_CASE("BinaryExpressionProcessor shift", "[language]")
{
  SECTION("<<")
  {
    std::filesystem::path path{PUGS_BINARY_DIR};
    path.append("tests").append(std::string{"binary_expression_processor_"} + std::to_string(getpid()));

    std::string filename = path.string();

    {
      std::ostringstream data;
      data << R"(import socket;)";
      data << "let fout:ostream, fout = ofstream(\"" << path.string() << "\");\n";
      data << R"(fout << 2 << " " << true << " " << 2 + 3 << "\n";
fout << createSocketServer(0);)";

      TAO_PEGTL_NAMESPACE::string_input input{data.str(), "test.pgs"};
      auto ast = ASTBuilder::build(input);

      ASTModulesImporter{*ast};
      ASTNodeTypeCleaner<language::import_instruction>{*ast};

      ASTSymbolTableBuilder{*ast};
      ASTNodeDataTypeBuilder{*ast};

      ASTNodeDeclarationToAffectationConverter{*ast};
      ASTNodeTypeCleaner<language::var_declaration>{*ast};

      ASTNodeExpressionBuilder{*ast};
      ExecutionPolicy exec_policy;
      ast->execute(exec_policy);
    }

    REQUIRE(std::filesystem::exists(filename));

    {
      std::string file_content;
      std::ifstream fin(filename.c_str());

      do {
        char c = fin.get();
        if (c != EOF) {
          file_content += c;
        }
      } while (fin);

      std::string expected = "2 true 5\n";
      char hbuf[NI_MAXHOST];
      ::gethostname(hbuf, NI_MAXHOST);
      expected += hbuf;
      expected += ':';

      REQUIRE(file_content.size() > expected.size());
      REQUIRE(file_content.substr(0, expected.size()) == expected);

      std::string suffix = file_content.substr(expected.size(), file_content.size() - expected.size());

      auto is_int = [](const std::string& s) {
        for (const char& c : s) {
          if (not std::isdigit(c)) {
            return false;
          }
        }
        return true;
      };

      REQUIRE(is_int(suffix));
    }

    std::filesystem::remove(filename);
    REQUIRE(not std::filesystem::exists(filename));
  }
}
