#include <utils/BacktraceManager.hpp>

#include <utils/Demangle.hpp>

#include <cmath>
#include <execinfo.h>
#include <iomanip>
#include <rang.hpp>
#include <regex>

bool BacktraceManager::s_show = false;

void
BacktraceManager::setShow(bool show_backtrace)
{
  s_show = show_backtrace;
}

BacktraceManager::BacktraceManager()
{
  const int size = 100;
  void* buffer[size];

  int ret    = ::backtrace(buffer, size);
  char** ptr = backtrace_symbols(buffer, ret);

  for (int i = 2; i < ret; ++i) {
    m_lines.push_back(ptr[i]);
  }

  free(ptr);
}

std::ostream&
operator<<(std::ostream& os, const BacktraceManager& btm)
{
  if (BacktraceManager::s_show) {
    const std::vector<std::string>& lines = btm.m_lines;

    const std::regex mangled_function(R"%(\(.*\+)%");
    const int width = std::log10(lines.size()) + 1;

    for (size_t i_line = 0; i_line < lines.size(); ++i_line) {
      const auto& line = lines[i_line];
      os << rang::fg::green << "[" << std::setw(width) << i_line + 1 << '/' << lines.size() << "] " << rang::fg::reset;
      std::smatch matchex;
      if (std::regex_search(line, matchex, mangled_function)) {
        std::string prefix   = matchex.prefix().str();
        std::string function = line.substr(matchex.position() + 1, matchex.length() - 2);
        std::string suffix   = matchex.suffix().str();

        os << prefix << '(';
        if (function.size() > 0) {
          os << rang::style::bold << demangle(function) << rang::style::reset;
        }
        os << '+' << suffix << '\n';
      } else {
        os << line << '\n';
      }
    }
  } else {
    os << rang::fg::yellow << "\n[To display backtrace launch pugs with the --backtrace option]" << rang::style::reset
       << '\n';
  }

  return os;
}
