#ifndef FREE_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define FREE_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class FreeBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "free(" << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::free;
  }

  FreeBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {
    ;
  }

  FreeBoundaryConditionDescriptor(const FreeBoundaryConditionDescriptor&) = delete;
  FreeBoundaryConditionDescriptor(FreeBoundaryConditionDescriptor&&)      = delete;

  ~FreeBoundaryConditionDescriptor() = default;
};

#endif   // FREE_BOUNDARY_CONDITION_DESCRIPTOR_HPP
