#ifndef DISCRETE_FUNCTION_INTERPOLER_HPP
#define DISCRETE_FUNCTION_INTERPOLER_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

#include <memory>

class DiscreteFunctionInterpoler
{
 private:
  std::shared_ptr<const IMesh> m_mesh;
  std::shared_ptr<const IDiscreteFunctionDescriptor> m_discrete_function_descriptor;
  const FunctionSymbolId m_function_id;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  std::shared_ptr<IDiscreteFunction> _interpolate() const;

  template <size_t Dimension>
  std::shared_ptr<IDiscreteFunction> _interpolate() const;

 public:
  std::shared_ptr<IDiscreteFunction> interpolate() const;

  DiscreteFunctionInterpoler(const std::shared_ptr<const IMesh>& mesh,
                             const std::shared_ptr<const IDiscreteFunctionDescriptor>& discrete_function_descriptor,
                             const FunctionSymbolId& function_id)
    : m_mesh{mesh}, m_discrete_function_descriptor{discrete_function_descriptor}, m_function_id{function_id}
  {}

  DiscreteFunctionInterpoler(const DiscreteFunctionInterpoler&) = delete;
  DiscreteFunctionInterpoler(DiscreteFunctionInterpoler&&)      = delete;

  ~DiscreteFunctionInterpoler() = default;
};

#endif   // DISCRETE_FUNCTION_INTERPOLER_HPP
