#ifndef DISCRETE_FUNCTION_INTEGRATOR_HPP
#define DISCRETE_FUNCTION_INTEGRATOR_HPP

#include <analysis/IQuadratureDescriptor.hpp>
#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/IDiscreteFunction.hpp>

#include <memory>

class DiscreteFunctionIntegrator
{
 private:
  std::shared_ptr<const IMesh> m_mesh;
  std::shared_ptr<const IQuadratureDescriptor> m_quadrature_descriptor;
  const FunctionSymbolId m_function_id;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  std::shared_ptr<IDiscreteFunction> _integrate() const;

  template <size_t Dimension>
  std::shared_ptr<IDiscreteFunction> _integrate() const;

 public:
  std::shared_ptr<IDiscreteFunction> integrate() const;

  DiscreteFunctionIntegrator(const std::shared_ptr<const IMesh>& mesh,
                             const std::shared_ptr<const IQuadratureDescriptor>& quadrature_descriptor,
                             const FunctionSymbolId& function_id)
    : m_mesh{mesh}, m_quadrature_descriptor{quadrature_descriptor}, m_function_id{function_id}
  {}

  DiscreteFunctionIntegrator(const DiscreteFunctionIntegrator&) = delete;
  DiscreteFunctionIntegrator(DiscreteFunctionIntegrator&&)      = delete;

  ~DiscreteFunctionIntegrator() = default;
};

#endif   // DISCRETE_FUNCTION_INTEGRATOR_HPP
