#ifndef WRITER_BASE_HPP
#define WRITER_BASE_HPP

#include <output/IWriter.hpp>

#include <string>

class IMesh;
class OutputNamedItemDataSet;

class WriterBase : public IWriter
{
 protected:
  const std::string m_base_filename;
  const double m_time_period;
  mutable double m_next_time;

  mutable std::vector<double> m_saved_times;

 private:
  template <typename DiscreteFunctionType>
  static void _register(const std::string& name, const DiscreteFunctionType&, OutputNamedItemDataSet&);

  template <size_t Dimension, template <size_t DimensionT, typename DataTypeT> typename DiscreteFunctionType>
  static void _register(const std::string& name, const IDiscreteFunction&, OutputNamedItemDataSet&);

  template <template <size_t DimensionT, typename DataTypeT> typename DiscreteFunctionType>
  static void _register(const NamedDiscreteFunction&, OutputNamedItemDataSet&);

 protected:
  std::shared_ptr<const IMesh> _getMesh(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const;

  OutputNamedItemDataSet _getOutputNamedItemDataSet(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const;

  virtual void write(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                     double time) const = 0;

 public:
  double getLastTime() const;

  void writeIfNeeded(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                     double time) const final;

  void writeForced(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                   double time) const final;

  WriterBase() = delete;

  WriterBase(const std::string& base_filename, const double& time_period);

  virtual ~WriterBase() = default;
};

#endif   // WRITER_BASE_HPP
