#ifndef MESH_RELAXER_HPP
#define MESH_RELAXER_HPP

class IMesh;

template <typename ConnectivityType>
class Mesh;

#include <memory>

class MeshRelaxer
{
 private:
  template <typename ConnectivityType>
  std::shared_ptr<const Mesh<ConnectivityType>> _relax(const Mesh<ConnectivityType>& source_mesh,
                                                       const Mesh<ConnectivityType>& destination_mesh,
                                                       const double& theta) const;

 public:
  std::shared_ptr<const IMesh> relax(const std::shared_ptr<const IMesh>& p_source_mesh,
                                     const std::shared_ptr<const IMesh>& p_destination_mesh,
                                     const double& theta) const;
  MeshRelaxer()  = default;
  ~MeshRelaxer() = default;
};

#endif   // MESH_RELAXER_HPP
