#ifndef MESH_FLAT_NODE_BOUNDARY_HPP
#define MESH_FLAT_NODE_BOUNDARY_HPP

#include <mesh/MeshNodeBoundary.hpp>

template <size_t Dimension>
class MeshFlatNodeBoundary final : public MeshNodeBoundary<Dimension>   // clazy:exclude=copyable-polymorphic
{
 public:
  using Rd = TinyVector<Dimension, double>;

 private:
  const Rd m_outgoing_normal;

  Rd _getNormal(const Mesh<Connectivity<Dimension>>& mesh);

  void _checkBoundaryIsFlat(const TinyVector<Dimension, double>& normal,
                            const TinyVector<Dimension, double>& origin,
                            const double length,
                            const Mesh<Connectivity<Dimension>>& mesh) const;

  Rd _getOutgoingNormal(const Mesh<Connectivity<Dimension>>& mesh);

 public:
  const Rd&
  outgoingNormal() const
  {
    return m_outgoing_normal;
  }

  MeshFlatNodeBoundary& operator=(const MeshFlatNodeBoundary&) = default;
  MeshFlatNodeBoundary& operator=(MeshFlatNodeBoundary&&) = default;

  template <size_t MeshDimension>
  friend MeshFlatNodeBoundary<MeshDimension> getMeshFlatNodeBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                                     const IBoundaryDescriptor& boundary_descriptor);

 private:
  template <typename MeshType>
  MeshFlatNodeBoundary(const MeshType& mesh, const RefFaceList& ref_face_list)
    : MeshNodeBoundary<Dimension>(mesh, ref_face_list), m_outgoing_normal(_getOutgoingNormal(mesh))
  {}

  template <typename MeshType>
  MeshFlatNodeBoundary(const MeshType& mesh, const RefNodeList& ref_node_list)
    : MeshNodeBoundary<Dimension>(mesh, ref_node_list), m_outgoing_normal(_getOutgoingNormal(mesh))
  {}

 public:
  MeshFlatNodeBoundary()                            = default;
  MeshFlatNodeBoundary(const MeshFlatNodeBoundary&) = default;
  MeshFlatNodeBoundary(MeshFlatNodeBoundary&&)      = default;
  ~MeshFlatNodeBoundary()                           = default;
};

template <size_t Dimension>
MeshFlatNodeBoundary<Dimension> getMeshFlatNodeBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                        const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_FLAT_NODE_BOUNDARY_HPP
