#ifndef CONCAT_EXPRESSION_PROCESSOR_HPP
#define CONCAT_EXPRESSION_PROCESSOR_HPP

#include <language/ast/ASTNode.hpp>
#include <language/node_processor/INodeProcessor.hpp>

template <typename B_DataT>
class ConcatExpressionProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

  PUGS_INLINE
  DataVariant
  _eval(const std::string& a, const DataVariant& b)
  {
    if constexpr (std::is_same_v<B_DataT, std::string>) {
      return a + std::get<B_DataT>(b);
    } else if constexpr (std::is_arithmetic_v<B_DataT>) {
      return a + std::to_string(std::get<B_DataT>(b));
    } else {
      std::ostringstream os;
      os << a << b;
      return os.str();
    }
  }

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    return this->_eval(std::get<std::string>(m_node.children[0]->execute(exec_policy)),
                       m_node.children[1]->execute(exec_policy));
  }

  ConcatExpressionProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // CONCAT_EXPRESSION_PROCESSOR_HPP
