#ifndef EIGENVALUE_SOLVER_HPP
#define EIGENVALUE_SOLVER_HPP

#include <algebra/PETScUtils.hpp>

#include <algebra/SmallMatrix.hpp>
#include <algebra/SmallVector.hpp>
#include <utils/Exceptions.hpp>
#include <utils/SmallArray.hpp>

class EigenvalueSolver
{
 private:
  struct Internals;

#ifdef PUGS_HAS_SLEPC
  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A, SmallArray<double>& eigenvalues);

  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A,
                                 SmallArray<double>& eigenvalues,
                                 std::vector<SmallVector<double>>& eigenvectors);

  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A,
                                 SmallArray<double>& eigenvalues,
                                 SmallMatrix<double>& P);
#endif   // PUGS_HAS_SLEPC

 public:
  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A, [[maybe_unused]] SmallArray<double>& eigenvalues)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A,
                            [[maybe_unused]] SmallArray<double>& eigenvalues,
                            [[maybe_unused]] std::vector<SmallVector<double>>& eigenvectors)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues, eigenvectors);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A,
                            [[maybe_unused]] SmallArray<double>& eigenvalues,
                            [[maybe_unused]] SmallMatrix<double>& P)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues, P);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  EigenvalueSolver();
  ~EigenvalueSolver() = default;
};

#endif   // EIGENVALUE_SOLVER_HPP
