#ifndef WRITER_BASE_HPP
#define WRITER_BASE_HPP

#include <output/IWriter.hpp>

#include <string>

class IMesh;
class OutputNamedItemValueSet;

class WriterBase : public IWriter
{
 protected:
  const std::string m_base_filename;
  const double m_time_period;
  mutable double m_next_time;

  mutable std::vector<double> m_saved_times;

 private:
  template <size_t Dimension, typename DataType>
  static void registerDiscreteFunctionP0(const std::string& name, const IDiscreteFunction&, OutputNamedItemValueSet&);

  template <size_t Dimension>
  static void registerDiscreteFunctionP0(const std::string& name, const IDiscreteFunction&, OutputNamedItemValueSet&);

  static void registerDiscreteFunctionP0(const NamedDiscreteFunction&, OutputNamedItemValueSet&);

 protected:
  std::shared_ptr<const IMesh> _getMesh(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const;

  OutputNamedItemValueSet _getOutputNamedItemValueSet(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const;

  virtual void write(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                     double time) const = 0;

 public:
  double getLastTime() const;

  void writeIfNeeded(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                     double time) const final;

  void writeForced(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                   double time) const final;

  WriterBase() = delete;

  WriterBase(const std::string& base_filename, const double& time_period);

  virtual ~WriterBase() = default;
};

#endif   // WRITER_BASE_HPP
