#ifndef GNUPLOT_WRITER_HPP
#define GNUPLOT_WRITER_HPP

#include <output/WriterBase.hpp>

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <output/OutputNamedItemValueSet.hpp>

class IMesh;

#include <string>

class GnuplotWriter : public WriterBase
{
 private:
  std::string _getDateAndVersionComment() const;

  std::string _getFilename() const;

  template <typename DataType>
  void _writeCellValue(const CellValue<DataType>& cell_value, CellId cell_id, std::ostream& fout) const;

  template <typename DataType>
  void _writeNodeValue(const NodeValue<DataType>& node_value, NodeId cell_id, std::ostream& fout) const;

  template <size_t Dimension>
  void _writePreamble(const OutputNamedItemValueSet& output_named_item_value_set, std::ostream& fout) const;

  template <typename DataType, ItemType item_type>
  void _writeValue(const ItemValue<DataType, item_type>& item_value,
                   CellId cell_id,
                   NodeId node_id,
                   std::ostream& fout) const;

  template <typename MeshType>
  void _writeValues(const std::shared_ptr<const MeshType>& mesh,
                    const OutputNamedItemValueSet& output_named_item_value_set,
                    std::ostream& fout) const;

  template <typename MeshType>
  void _write(const std::shared_ptr<const MeshType>& mesh,
              const OutputNamedItemValueSet& output_named_item_value_set,
              double time) const;

 public:
  void writeMesh(const std::shared_ptr<const IMesh>& mesh) const final;

  void write(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
             double time) const final;

  GnuplotWriter(const std::string& base_filename, const double time_period) : WriterBase(base_filename, time_period) {}

  ~GnuplotWriter() = default;
};

#endif   // GNUPLOT_WRITER_HPP
